
mEmitSpeed = 10.0;
mScale = 1.00;
mBlendMode = kBlendNormal;

mTextureName = "heart";
mMaxParticles = 8.50;

-- ------------------------------------------------------------
-- Define our particle characteristics

pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

-- Set the particle texture
SetTexture(mTextureName);

-- Set the blend mode
SetBlendMode(mBlendMode);

-- LAST, we set the total number of particles in the particle
-- system. This doesn't 'create' the particles, but rather
-- allocates a block of 'dead' particles that can be created
-- below.
SetNumParticles(mMaxParticles);

-- ------------------------------------------------------------
-- Initialization rules.
-- 
-- The following rules define how particles are created.
--
-- Any parameter below in initialization or animation rules that 
-- is a scalar, Color(), or Vec2() can alternaly take a function 
-- that returns the same type--and most functions can take any type
-- and will return that same type. The exception is any function
-- that's expecting a scalar in certain parameter positions.

-- Define dLocus for FluidFX; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dLocus then
   dLocus= Vec2(0,0) ; 
end

-- Pick a position randomly, within a range of values.
-- dLocus is defined in swarm.cpp and added to the random
-- range
pPosition:Init( fRange( Vec2(-10,-10), Vec2(10,0) )+dLocus );

-- Pick a velocity within a range
pVelocity:Init( fRange( Vec2(-70,-180), Vec2(70,-150) ) );

-- Start scale at 0.5
pScale:Init( mScale );

-- Start age as 0 milliseconds
pAge:Init(0);

-- Start initial rotation as a random angle
pSpin:Init( -90 );

-- Start spin velocity random from -10 to 10
pSpinSpeed:Init( 0 ); -- fRange( -3, 3 ) );

-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--
-- The following rules define how particles animate.
-- Each rule is applied on each frame of animation.

-- Add velocity scaled by time to position
pPosition:Anim( pPosition + fTimeScale(pVelocity) );

-- Add 1/second to scale
pScale:Anim( pScale + fTimeScale(1.5) );

-- Add gravity scaled by time to velocity
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,450)) );

-- Fade (using age) from white to yellow to black. Assumes
-- the first parameter is a number of elapsed milliseconds,
-- though can work to linearly interpolate using first 
-- scalar parameter between any value types.
pColor:Anim( 
   fFade( pAge,
      Color(1,0,0,1),500,
      Color(1,0.4,0,0) ) -- to final color
   );

-- Spin by pSpinSpeed scaled by time
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Set the particle's "Up" vector to the current user variable
-- "pSpin"
pUp:Anim( f2dRotation( pSpin ) );

-- Age the particle using age function
pAge:Anim( pAge+fAge() );

-- General Anim functions
-- Expire particles over 700 ms old
Anim( fExpire( fGreater(pAge,1000) ) );

-- ------------------------------------------------------------
-- Create initial particles (optional)
-- CreateParticles( 1 );

-- ------------------------------------------------------------

-- A function to run as we're executing
-- seconds - how many seconds have elapsed
gActiveTime = 0.55;
gIsDone = 0;

function Update(seconds)
   gActiveTime = gActiveTime - seconds;
   if gActiveTime > 0.0 then
      CreateParticles( seconds * mEmitSpeed );
   elseif gActiveTime < -0.6 then
      gIsDone = 1;
   end
end
